<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="MFMT_MT002001">
    <title>Act Reference</title>
    <rule context="$element">
        <!--assert role="error" test="not(@classCode) or @classCode='CATEGORY'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActClass.htm#CATEGORY"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@classCode moet 'CATEGORY' zijn</assert>
            <assert role="error" test="not(@moodCode) or @moodCode='EVN'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#EVN"
            >MFMT_MT902001NL: <value-of select="local-name(.)"/>/@moodCode moet 'EVN' zijn</assert-->
        
        <let name="codeValue" value="../../hl7:code/@code"/>
        <let name="codeSystem" value="../../hl7:code/@codeSystem"/>
        
        <let name="classCode" value="@classCode"/>
        <let name="classCodeRoot" value="'2.16.840.1.113883.5.6'"/>
        <let name="expectClassCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$classCodeRoot]/@extension"/>
        
        <!-- Niet alle ActRegistryCodes hebben reeds een reference element -->
        <assert role="error" test="@classCode"
            >MFMT_MT002001: @classCode is verplicht</assert>
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $classCode=$expectClassCode"
            >MFMT_MT002001: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de classCode van de ActReference '<value-of select="@classCode"/>'. Verwacht werd '<value-of select="$expectClassCode"/>'.</assert>
        
        <let name="moodCode" value="@moodCode"/>
        <let name="moodCodeRoot" value="'2.16.840.1.113883.5.1001'"/>
        <let name="expectMoodCode" value="document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference[@root=$moodCodeRoot]/@extension"/>
        
        <assert role="error" test="not($classCode='CATEGORY') or $moodCode='EVN'"
            >MFMT_MT002001: @moodCode moet 'EVN' zijn voor categorale aanmeldingen</assert>
        
        <assert role="error" test="$classCode='CATEGORY' or 
            not(document(concat('../vocab/',$codeSystem,'.xml'))/*/hl7:code[@code=$codeValue]/hl7:reference) or
            $moodCode=$expectMoodCode"
            >MFMT_MT002001: Gegevenssoort '<value-of select="$codeValue"/>' komt niet overeen met de moodCode van de ActReference '<value-of select="@moodCode"/>'. Verwacht werd '<value-of select="$expectMoodCode"/>'.</assert>
    </rule>
    
    
    <rule context="$element/hl7:id">
        <extends rule="II"/>
        <!-- 20140425 In de nieuwe VWI is id geen element meer en hoeft deze niet te worden (op)geleverd -->
        <!--<assert role="error" test="not(@nullFlavor)"
            >MFMT_MT002001: id moet een waarde bevatten</assert>-->
    </rule>
    
    <rule context="$element/hl7:code">
        <extends rule="CE"/>
    </rule>
    
    <rule context="$element/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
        <assert role="error" test="not(@xsi:type) or string(@xsi:type)='IVL_TS'"
            >MFMT_MT002001: effectiveTime/@xsi:type moet, indien aanwezig, datatype IVL&lt;TS&gt; hebben</assert>
        <assert role="error" test="(@value and not(*)) or ((hl7:low/@value or hl7:high/@value) and not(@value) and not(hl7:width or hl7:center))"
            >MFMT_MT002001: alleen effectiveTime/@value (exact datum/tijdstip), of een effectiveTime/low (begin periode) en/of effectiveTime/high (einde periode) zijn toegestaan</assert>
        <assert role="warning" test="not(../hl7:statusCode/@code='active' and hl7:high)"
            >MFMT_MT002001: element effectiveTime/high (einde geldigheidsperiode) kan geen waarde hebben indien statusCode='active' (actuele status geldigheid), tenzij het een waarde in de toekomst betreft</assert>
        <assert role="warning"
            test="if (../hl7:statusCode/@code='aborted' or
                ../hl7:statusCode/@code='cancelled' or ../hl7:statusCode/@code='completed' or 
                ../hl7:statusCode/@code='nullified' or ../hl7:statusCode/@code='obsolete') then (hl7:high/@value or hl7:high/@nullFlavor) else (not(hl7:high/@value))"
            >MFMT_MT002001: element effectiveTime/high moet een (null) waarde hebben indien statusCode is 'aborted', 'cancelled', 'completed', 'nullified' of 'obsolete'. Anders mag effectiveTime/high/@value geen waarde hebben.</assert>
    </rule>

    <title>recordTarget</title>
    <rule context="$element/hl7:recordTarget/hl7:patient">
        <assert role="warning" test="count(hl7:id)=1"
            >MFMT_MT002001: alleen het burgerservicenummer van de patiënt wordt opgeslagen</assert>
    </rule>
    
    <rule context="$element/hl7:recordTarget/hl7:patient/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
            >MFMT_MT002001: recordTarget/patient/id moet een burgerservicenummer zijn</assert>
    </rule>
    
    <rule context="$element/hl7:recordTarget/hl7:patient/hl7:statusCode">
        <extends rule="CS"/>
        <assert role="error" test="@code='active'"
            >MFMT_MT002001: recordTarget/patient/statusCode moet "active" zijn</assert>
    </rule>
    
    <rule context="$element/hl7:recordTarget/hl7:patient/hl7:Person">
        <assert role="error" test="(@nullFlavor and not(hl7:*)) or (hl7:* and not(@nullFlavor))"
            >MFMT_MT002001: recordTarget/patient/Person mag null zijn, maar dan mogen er geen persoonsgegevens zijn en vice versa</assert>
    </rule>
    
    <title>authorOrPerformer</title>
    <rule context="$element/hl7:authorOrPerformer">
        <assert role="error" test="@typeCode='AUT' or @typeCode='PRF'"
            >MFMT_MT002001: authorOrPerformer/@classCode moet 'AUT' of 'PRF' zijn</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:id"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/id moet aanwezig zijn</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:code[not(@code='00.000')] or ../hl7:overseer"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/code (niet '00.000') moet aanwezig zijn, tenzij er een hl7:overseer is</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:Organization/hl7:id"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/Organization/id moet aanwezig zijn</assert>
    </rule>
    
    <rule context="$element/hl7:authorOrPerformer/hl7:time">
        <extends rule="IVL_TS"/>
    </rule>
    
    <rule context="$element/hl7:authorOrPerformer/hl7:assignedEntity/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.528.1.1007.3.1'"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/id moet een UZI-nummer zijn</assert>
    </rule>
    
    <rule context="$element/hl7:authorOrPerformer/hl7:assignedEntity/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/code moet een UZI-rolcode zijn</assert>
    </rule>
    
    <rule context="$element/hl7:authorOrPerformer/hl7:assignedEntity/hl7:Organization/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.528.1.1007.3.3'"
            >MFMT_MT002001: authorOrPerformer/assignedEntity/Organization/id moet een UZI-registerabonneennummer zijn</assert>
    </rule>
    
    <title>overseer</title>
    <rule context="$element/hl7:overseer">
        <assert role="error" test="@typeCode='RESP'"
            >MFMT_MT002001: overseer/@classCode moet 'RESP'</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:id"
            >MFMT_MT002001: overseer/assignedEntity/id moet aanwezig zijn</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:code[not(@code='00.000')]"
            >MFMT_MT002001: overseer/assignedEntity/code (niet '00.000') moet aanwezig zijn</assert>
        <assert role="error" test="hl7:assignedEntity/hl7:Organization/hl7:id"
            >MFMT_MT002001: overseer/assignedEntity/Organization/id moet aanwezig zijn</assert>
    </rule>
    
    <rule context="$element/hl7:overseer/hl7:time">
        <extends rule="IVL_TS"/>
    </rule>
    
    <rule context="$element/hl7:overseer/hl7:assignedEntity/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.528.1.1007.3.1'"
            >MFMT_MT002001: overseer/assignedEntity/id moet een UZI-nummer zijn</assert>
    </rule>
    
    <rule context="$element/hl7:overseer/hl7:assignedEntity/hl7:code">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.15.111'"
            >MFMT_MT002001: overseer/assignedEntity/code moet een UZI-rolcode zijn</assert>
    </rule>
    
    <rule context="$element/hl7:overseer/hl7:assignedEntity/hl7:Organization/hl7:id">
        <extends rule="II"/>
        <assert role="error" test="@root='2.16.528.1.1007.3.3'"
            >MFMT_MT002001: overseer/assignedEntity/Organization/id moet een UZI-registerabonneennummer zijn</assert>
    </rule>
</pattern>